package main

import (
	"fmt"
	"github.com/veandco/go-sdl2/img"
	"github.com/veandco/go-sdl2/sdl"
	"github.com/veandco/go-sdl2/ttf"
	"math/rand"
	"os"
	"strconv"
	"time"
)

var rands int32
var count int32
var score int
var rect sdl.Rect
var ss uint32
var MouseX int32
var MouseY int32
var state int32
var event sdl.Event
var running = true
var winTitle string = "Go-SDL2 Texture"
var winWidth, winHeight int32 = 1024, 768
var imageCharaName string = "kasa.png"
var imageBotaName string = "bota2.png"
var imagebgName string = "j.png"

func run() int {
	var font *ttf.Font
	var window *sdl.Window
	var renderer *sdl.Renderer
	var texturebota *sdl.Texture
	var texturebg *sdl.Texture
	var texturechara *sdl.Texture
	var texturefont *sdl.Texture
	var solid *sdl.Surface
	//var dst sdl.Rect var src, dst ,srcbg,dstbg sdl.Rect
	var err error
	window, err = sdl.CreateWindow(winTitle, sdl.WINDOWPOS_UNDEFINED, sdl.WINDOWPOS_UNDEFINED, winWidth, winHeight, sdl.WINDOW_SHOWN)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Failed to create window: %s\n", err)
		return 1
	}
	defer window.Destroy()
	renderer, err = sdl.CreateRenderer(window, -1, sdl.RENDERER_ACCELERATED)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Faled to create renderer:%s\n", err)
		return 1
	}
	defer renderer.Destroy()

	imagebg, err := img.Load(imagebgName)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Failed to load PNG: %s\n", err)
		return 3
	}
	defer imagebg.Free()
	imagebota, err := img.Load(imageBotaName)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Failed to load PNG: %s\n", err)
		return 3
	}
	defer imagebota.Free()
	imagechara, err := img.Load(imageCharaName)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Failed to load PNG: %s\n", err)
		return 3
	}
	defer imagechara.Free()

	texturebg, err = renderer.CreateTextureFromSurface(imagebg)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Failed to create texture: %s\n", err)
		return 4
	}
	defer texturebg.Destroy()
	texturechara, err = renderer.CreateTextureFromSurface(imagechara)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Failed to create texture: %s\n", err)
		return 4
	}
	defer texturebota.Destroy()
	texturebota, err = renderer.CreateTextureFromSurface(imagebota)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Failed to create texture: %s\n", err)
		return 4
	}
	defer texturebota.Destroy()

	var src1 = sdl.Rect{0, 0, 100, 100}
	var dst1 = sdl.Rect{0, 0, 100, 100}
	//var atari = sdl.Rect{0, 0, 200, 200}
	var src2 = sdl.Rect{0, 0, 100, 100}
	var dst2 = sdl.Rect{100, 100, 100, 100}
	var src3 = sdl.Rect{0, 0, 100, 100}
	var dst3 = sdl.Rect{100, 100, 100, 100}
	//	var src4 = sdl.Rect{0, 0, 100, 100}
	//	var dst4 = sdl.Rect{0, 0, 100, 100}
	//	var src5 = sdl.Rect{0, 0, 100, 100}
	//	var dst5 = sdl.Rect{0, 0, 100, 100}
	//	var src6 = sdl.Rect{0, 0, 100, 100}
	//var dst6 = sdl.Rect{0, 0, 100, 100}
	var src8 = sdl.Rect{0, 0, 200, 200}
	var dst8 = sdl.Rect{0, 0, 200, 200}
	var src7 = sdl.Rect{0, 0, 400, 400}
	var dst7 = sdl.Rect{0, 0, 100, 100}
	var srcbg = sdl.Rect{0, 0, 800, 600}
	var dstbg = sdl.Rect{0, 0, 1024, 768}
	count = 10
	//	dst4.X = -300
	//	dst5.X = -400
	//	dst6.X = -500
	//	for i := 0; i < 10; i++ {
	dst7.Y = 100
	dst7.X = 100
	rands = int32(rand.Intn(1024))
	dst1.X = int32(rands)
	rands = int32(rand.Intn(1024))
	dst2.X = int32(rands)
	dst2.X = 50
	rands = int32(rand.Intn(1024))
	dst3.X = int32(rands)
	//		dst2.Y = dst2.Y + int32(i)
	dst3.X = 150
	rands = int32(rand.Intn(1024))
	dst3.X = int32(rands)
	for {
		var strscore string
		strscore = strconv.Itoa(score)
		if err := ttf.Init(); err != nil {
			fmt.Fprintf(os.Stderr, "Failed to initialize TTF::%s\n", err)
			return 6
		}
		if font, err = ttf.OpenFont("VL.ttf", 32); err != nil {
			fmt.Fprintf(os.Stderr, "Faled to open font:%s\n", err)
			return 7
		}
		defer font.Close()
		if solid, err = font.RenderUTF8Solid("SCORE "+strscore, sdl.Color{255, 0, 0, 255}); err != nil {
			fmt.Fprintf(os.Stderr, "Failed to get window surface:%s\n", err)
			return 8
		}
		texturefont, err = renderer.CreateTextureFromSurface(solid)
		if err != nil {
			fmt.Fprintf(os.Stderr, "Failed to create texture: %s\n", err)
			return 9
		}
		defer texturefont.Destroy()
		//		dst.X = 0
		//		dst.Y = dst.Y + int32(i)
		//		dst4.X = 350
		//		dst4.Y = dst4.Y + int32(i)
		//		dst5.X = 450
		//		dst5.Y = dst5.Y + int32(i)
		//		dst6.X = 550
		//		dst6.Y = dst6.Y + int32(i)
		for event = sdl.PollEvent(); event != nil; event = sdl.PollEvent() {
			switch t := event.(type) {
			case *sdl.QuitEvent:
				running = false
			case *sdl.MouseMotionEvent:
				MouseX, MouseY, state := sdl.GetMouseState()
				dst7.X = MouseX
				dst7.Y = MouseY
				ss = state
				//fmt.Println(t.motion.x)
				//fmt.Println("8")
				//dst7.Y = dst7.Y + 1
			case *sdl.KeyboardEvent:
				switch t.Keysym.Sym {
				case sdl.K_RIGHT:
					dst7.X = dst7.X + 1
				case sdl.K_LEFT:
					dst7.X = dst7.X - 1
				}
			default:
			}
		}

		//dst7.X = 111
		//dst7.Y = 111
		//aaa
		//renderer.SetDrawColor(255, 0, 0, 255)
		//		renderer.FillRect(&sdl.Rect{0, 0, int32(winWidth), int32(winHeight)})
		//renderer.Copy(texture, &sdl.Rect{ 32, 10, 500, 400}, &dst)
		//renderer.Copy(texture, &sdl.Rect{0, 0, 50 - int32(i), 50}, &sdl.Rect{0, 0, 50 + int32(i), 50})
		//renderer.Copy(texturemouse,&sr sdl.RendererDrawRect
		//#renderer.FillRect(&sdl.Rect{0, 0, 100, 100}, sdl.MapRGB(Renderer.Format, 0, 0, 255))

		//sdl.RenderDrawRect(renderer, &src7)
		//renderer.Copy(texture, &dst7, &dst7)

		renderer.Copy(texturebg, &srcbg, &dstbg)
		//if dst7.X > (dst1.X+25) && dst7.Y > (dst1.Y+25) && dst7.X > (dst7.X-25) && dst7.Y > (dst1.Y-25) {
		rect = sdl.Rect{dst7.X, dst1.Y, 200, 200}
		//renderer.SetDrawColor(255, 255, 0, 255)
		//renderer.FillRect(&rect)
		//renderer.SetDrawColor(222, 222, 222, 222)
		//renderer.DrawLine(0, 0, 200, 200)
		renderer.Copy(texturefont, &src8, &dst8)
		renderer.Copy(texturebota, &src1, &dst1)
		renderer.Copy(texturebota, &src2, &dst2)
		renderer.Copy(texturebota, &src3, &dst3)
		//renderer.Copy(texturebota, &src4, &dst4)
		//renderer.Copy(texturebota, &src5, &dst5)
		//renderer.Copy(texturebota, &src6, &dst6)
		renderer.Copy(texturechara, &src7, &dst7)
		renderer.Present()
		renderer.Clear()
		sdl.Delay(100)
		//	fmt.Println(dst4.W)
		//	fmt.Println(dst4.H)
		//if MouseX < (dst3.X+55) && MouseY < (dst3.Y+55) && MouseX > (dst3.X-15) && MouseY > (dst3.Y-15) {

		fmt.Println(dst1.X)
		fmt.Println(dst1.Y)
		fmt.Println(dst1.W)
		fmt.Println(dst1.H)
		fmt.Println(dst2.X)
		fmt.Println(dst2.Y)
		fmt.Println(dst2.W)
		fmt.Println(dst2.H)
		/*fmt.Println(dst7.X)
		fmt.Println(dst7.Y)
		fmt.Println(count)*/
		//if dst7.X < (dst1.X+100) && dst7.Y < (dst1.Y+100) && dst7.X > (dst1.X-15) && dst7.Y > (dst1.Y-15) {
		// dst7.X > 0 && dst7.Y > 100 && dst7.X < 0 && dst7.Y < 100 {
		//dst1.X = 400
		dst1.Y = dst1.Y + count
		dst2.Y = dst2.Y + count
		dst3.Y = dst3.Y + count
		rand.Seed(time.Now().UnixNano())
		//if dst7.X > 500 && dst7.Y > 500 {
		//dst7がマウスポインター
		//	dst1.Y = 0
		if dst7.X < (dst1.X+25) && dst7.Y < (dst1.Y+25) && dst7.X > (dst1.X-25) && dst7.Y > (dst1.Y-25) {
			//if dst7.X > dst1.Y && dst7.Y > 500 {
			dst1.Y = 0
			score = score + 1
			rands = int32(rand.Intn(1024))
			fmt.Println(rand.Intn(480))
			dst1.X = int32(rands)
		}
		if dst7.X < (dst2.X+25) && dst7.Y < (dst2.Y+25) && dst7.X > (dst2.X-25) && dst7.Y > (dst2.Y-25) {
			//if dst7.X > dst1.Y && dst7.Y > 500 {
			dst2.Y = 0
			score = score + 1
			rands = int32(rand.Intn(1024))
			fmt.Println(rand.Intn(480))
			dst2.X = int32(rands)
		}
		if dst7.X < (dst3.X+25) && dst7.Y < (dst3.Y+25) && dst7.X > (dst3.X-25) && dst7.Y > (dst3.Y-25) {
			//if dst7.X > dst1.Y && dst7.Y > 500 {
			dst3.Y = 0
			score = score + 1
			rands = int32(rand.Intn(1024))
			dst3.X = int32(rands)
		}
		//if dst1.Y > 768 {
		//if dst1.Y > 768 {
		//}
		//	if dst4.Y > 480 {
		//		dst4.Y = 0
		//	}
		if dst1.Y > 768 {
			dst1.Y = 0
			rands = int32(rand.Intn(1024))
			dst1.X = int32(rands)
		}
		if dst2.Y > 768 {
			dst2.Y = 0
			rands = int32(rand.Intn(1024))
			dst2.X = int32(rands)
		}
		if dst3.Y > 768 {
			dst3.Y = 0
			rands = int32(rand.Intn(1024))
			dst3.X = int32(rands)
		}

	}

	return 0
}
func main() {
	os.Exit(run())
}
